[CmdletBinding()]
param(
    [Parameter(ValueFromPipelineByPropertyName = $True, Position = 0)][alias("URL")]
    [String] $URI = "http://dl.delivery.mp.microsoft.com/filestreamingservice/files/ad6e5e87-14da-4577-a9da-dd345685efe8/22000.318.211104-1236.co_release_svc_refresh_CLIENTCHINA_RET_x64FRE_zh-cn.esd"
)

# Read the header (208 bytes)
$request = [System.Net.WebRequest]::Create($URI)
$request.Method = "GET"
$request.AddRange("bytes", 0, 208)
$reader = New-Object System.IO.BinaryReader($request.GetResponse().GetResponseStream())
$bytes = New-Object Byte[](208)
$reader.Read($bytes, 0, 207) | Out-Null

# Check the magic header
if ([System.Text.Encoding]::ASCII.GetString($bytes[0..4]) -ne "MSWIM") {
    throw "Invalid WIM/ESD file, incorrect magic string in header"
}

# Get the offset and length
$offset = [System.BitConverter]::ToInt64($bytes, 80)
$length = [System.BitConverter]::ToInt64($bytes, 88)

# Read the XML from that location
$request = [System.Net.WebRequest]::Create($URI)
$request.Method = "GET"
$request.AddRange("bytes", $offset, $offset + $length - 1)
$reader = New-Object System.IO.StreamReader($request.GetResponse().GetResponseStream())
[xml]$xml = $reader.ReadToEnd()

$xml.WIM.IMAGE | % {
    New-Object -TypeName PSObject -Property @{
        INDEX = $_.INDEX
        NAME = $_.NAME
        DESCRIPTION = $_.DESCRIPTION
        FLAGS = $_.FLAGS
        EDITION = $_.WINDOWS.EDITIONID
        LANGUAGE = $_.WINDOWS.LANGUAGES.LANGUAGE
        VERSION = "$($_.WINDOWS.VERSION.MAJOR).$($_.WINDOWS.VERSION.MINOR).$($_.WINDOWS.VERSION.BUILD).$($_.WINDOWS.VERSION.SPBUILD)"
    }
}