Get-AppxProvisionedPackage -online | % {
	# Get the main app package location using the manifest
	$loc = Split-Path ( [Environment]::ExpandEnvironmentVariables($_.InstallLocation) ) -Parent
	If ((Split-Path $loc -Leaf) -ieq 'AppxMetadata') {
		$loc = Split-Path $loc -Parent
	}
	# Get a pattern for finding related folders
	$matching = Join-Path -Path (Split-Path $loc -Parent) -ChildPath "$($_.DisplayName)*"
	$size = (Get-ChildItem $matching -Recurse -ErrorAction Ignore | Measure-Object -Property Length -Sum).Sum
	# Add the results to the output
	$_ | Add-Member -NotePropertyName Size -NotePropertyValue $size
	$_ | Add-Member -NotePropertyName InstallFolder -NotePropertyValue $loc
	$_
} | Select DisplayName, PackageName, Version, InstallFolder, Size