# Find the ADK
try
{
    $kitsRoot = Get-ItemPropertyValue -Path "HKLM:\Software\Microsoft\Windows Kits\Installed Roots" -Name KitsRoot10
}
catch
{
    Write-Error "ADK is not installed."
    return 1
}

# Find Windows PE
$peRoot = $kitsRoot + "Assessment and Deployment Kit\Windows Preinstallation Environment\"
if (-not (Test-Path $peRoot)) {
    Write-Error "Windows PE is not installed."
    return 2
}

$platforms = @("amd64", "x86", "arm64")

$platforms | % {

    $platform = $_

    # Copy the winpe.wim
    $peFile = "$peRoot\$platform\en-us\winpe.wim";
    if (-not (Test-Path $peFile)) {
        Write-Error "Windows PE file " + $peFile + " does not exist."
        return 3
    }
    $peNew = [Environment]::GetFolderPath("MyDocuments") + "\winpe_$platform.wim"
    Copy-Item -Path $peFile -Destination $peNew -Force

    # Mount the winpe.wim
    $peMount = "$($env:TEMP)\mount_$platform"
    if (-not (Test-Path $peMount)) {
        MkDir $peMount
    }
    Mount-WindowsImage -Path $peMount -ImagePath $peNew -Index 1

    # Add the needed components to it
    $packagePath = "$peRoot\$platform\WinPE_OCs"
    ("winpe-hta", "winpe-scripting", "winpe-wmi", "winpe-securestartup") | % {
        Write-Host "Adding package $_"
        Add-WindowsPackage -Path $peMount -PackagePath "$packagePath\$($_).cab"
        Add-WindowsPackage -Path $peMount -PackagePath "$packagePath\en-us\$($_)_en-us.cab"    
    }

    # Inject any needed drivers
    if (Test-Path ".\$platform\Drivers") {
        Write-Host "Injecting drivers from .\$platform\Drivers"
        Add-WindowsDriver -Path $peMount -Driver ".\$platform\Drivers" -Recurse
    }

    # Inject any needed update
    if (Test-Path ".\$platform\Updates") {
        Write-Host "Injecting updates from .\$platform\Updates"
        Dir ".\$platform\Updates" | % { Add-WindowsPackage -Path $peMount -PackagePath ".\$platform\Updates\$_" }
    }

    # Remove the old background
    takeown /f "$peMount\Windows\system32\winpe.jpg"
    icacls "$peMount\Windows\system32\winpe.jpg" /grant everyone:f
    Remove-Item "$peMount\Windows\system32\winpe.jpg"

    # Add the extra files
    Copy-Item -Path "winpeshl.ini" -Destination "$peMount\windows\system32" -Force
    Copy-Item -Path "Unattend_PE_$platform.xml" -Destination "$peMount\unattend.xml" -Force
    Copy-Item -Path "bootstrap.vbs" -Destination "$peMount\bootstrap.vbs" -Force
    Copy-Item -Path "winpe.jpg" -Destination "$peMount\Windows\system32\winpe.jpg" -Force
    # Copy-Item -Path "startnet.cmd" -Destination "$peMount\Windows\system32\startnet.cmd" -Force

    # Unmount and commit
    Dismount-WindowsImage -Path $peMount -Save

    # Report completion
    Write-Host "Windows PE generated: $peNew"
}
