# Details
$peSource = [Environment]::GetFolderPath("MyDocuments") + "\winpe_amd64.wim"
$peArch = "amd64"
$isoNew = [Environment]::GetFolderPath("MyDocuments") + "\winpe_$peArch.iso"

# Find the ADK
try
{
    $kitsRoot = Get-ItemPropertyValue -Path "HKLM:\Software\Microsoft\Windows Kits\Installed Roots" -Name KitsRoot10
}
catch
{
    Write-Error "ADK is not installed."
    exit 1
}

# Find Windows PE
$peRoot = $kitsRoot + "Assessment and Deployment Kit\Windows Preinstallation Environment\"
if (-not (Test-Path $peRoot)) {
    Write-Error "Windows PE is not installed."
    exit 2
}

# Create a temporary folder
$isoTemp = "$($env:TEMP)\Media"
if (Test-Path $isoTemp) {
    Remove-Item $isoTemp -Recurse -Force
}
Mkdir $isoTemp | Out-Null

# Copy the boot files to the media
Write-Host "Copying boot files"
Copy-Item -Path "$peRoot\$peArch\Media\*" -Destination "$($isoTemp)\" -Recurse -Force

# Copy the PE WIM to the \Sources folder
Write-Host "Copying Windows PE boot image"
Mkdir -Path "$($isoTemp)\Sources" | Out-Null
Copy-Item -Path $peSource -Destination "$($isoTemp)\Sources\boot.wim"

# Capture the ISO
$oscdimgDir = "$($kitsRoot)Assessment and Deployment Kit\Deployment Tools\$($env:PROCESSOR_ARCHITECTURE)\Oscdimg"
$oscdimg = "$oscdimgDir\OSCDIMG.EXE"
& "$oscdimg" -m -o -u2 -udfver102 -bootdata:2`#p0,e,b$oscdimgDir\etfsboot.com`#pEF,e,b$oscdimgDir\Efisys.bin $isoTemp $isoNew
