import logging
import json
import msal
import requests
import pandas

# Globals
token = None
graphApiVersion = "beta"
uri = "https://graph.microsoft.com/{v}/{r}"
headers = None

# Functions
def authenticate():
    global token
    global headers
    authority = "https://login.microsoftonline.com/contosocm.onmicrosoft.com"
    appID = "9284b141-c694-48a5-bf31-b467cbc5780c"
    appSecret = "your secret goes here"
    scope = ["https://graph.microsoft.com/.default"]

    app = msal.ConfidentialClientApplication(
        appID, authority=authority, client_credential = appSecret)
    token = app.acquire_token_silent(scope, account=None)
    if not token:
        token = app.acquire_token_for_client(scopes=scope)
    headers = {'Authorization': 'Bearer ' + token['access_token']}
    return

def devices(Format=True):
    return query(graphApiVersion, "deviceManagement/windowsAutopilotDeviceIdentities", Format)

def profiles(Format=True):
    return query(graphApiVersion, "deviceManagement/windowsAutopilotDeploymentProfiles", Format)

def enrollmentStatusPages(Format=True):
    return query(graphApiVersion, "deviceManagement/deviceEnrollmentConfigurations", Format)

def events(Format=True):
    return query(graphApiVersion, "deviceManagement/autopilotEvents", Format)

def query(v, r, Format=True):
    dest = uri.format(v=v, r=r)
    result = requests.get(dest, headers=headers).json()
    if Format:
        print(pandas.json_normalize(result["value"]))
    else:
        return result["value"]
