#r "Microsoft.WindowsAzure.Storage"
#r "Newtonsoft.Json"

using System.Net;
using System.Globalization;
using System.Text;
using Microsoft.AspNetCore.Mvc;
using Microsoft.WindowsAzure.Storage;
using Microsoft.WindowsAzure.Storage.Table;
using Microsoft.Extensions.Primitives;
using Newtonsoft.Json;

public static async Task<IActionResult> Run(HttpRequest req, CloudTable countTable, ILogger log)
{
    // Get the name prefix
    string prefix = req.Query["prefix"];

    // Get the current count
    TableOperation retrieveOperation = TableOperation.Retrieve("A", "A");
    TableResult result = await countTable.ExecuteAsync(retrieveOperation);
    DynamicTableEntity row = (DynamicTableEntity) result.Result;
    EntityProperty current;
    row.Properties.TryGetValue("CurrentCount", out current);

    // Increment
    current.Int32Value++;

    // Save the incremented value
    TableOperation replaceOperation = TableOperation.Merge(row);
    await countTable.ExecuteAsync(replaceOperation);

    // Return the name 
    GeneratedName newName = new GeneratedName {
        Name = prefix + current.Int32Value.Value.ToString("D8")
    };
    log.LogInformation($"Generated name: {newName.Name}");
    return new JsonResult(newName);
}

public class GeneratedName
{
    public string Name;
}